import { z } from 'zod';
import { APIResponseSchema } from "../api.js";
import { OrgResponseError } from "./util.js";
export const OrgEnvDataSchema = z.object({
    id: z.string().describe('the organization id'),
    env: z.record(z.string(), z.string()).optional().describe('environment variables'),
    secrets: z.record(z.string(), z.string()).optional().describe('secrets (may be masked)'),
});
export const OrgEnvGetResponseSchema = APIResponseSchema(OrgEnvDataSchema);
/**
 * Get environment variables and secrets for an organization.
 * Secrets are masked by default unless mask=false is specified.
 * Note: Unmasked values require admin/owner role.
 */
export async function orgEnvGet(client, request) {
    const { id, mask = true } = request;
    const resp = await client.get(`/cli/organization/${id}/env?mask=${mask}`, OrgEnvGetResponseSchema);
    if (!resp.success) {
        throw new OrgResponseError({ message: resp.message ?? 'failed to get org env' });
    }
    if (!resp.data) {
        throw new OrgResponseError({ message: 'failed to get org env: no data returned' });
    }
    return resp.data;
}
//# sourceMappingURL=env-get.js.map