import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const EvalRunDetailSchema: z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodNullable<z.ZodString>;
    evalName: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodNullable<z.ZodString>;
    projectId: z.ZodString;
    orgId: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>;
export declare const EvalRunGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        sessionId: z.ZodString;
        evalId: z.ZodString;
        evalIdentifier: z.ZodNullable<z.ZodString>;
        evalName: z.ZodNullable<z.ZodString>;
        agentIdentifier: z.ZodNullable<z.ZodString>;
        projectId: z.ZodString;
        orgId: z.ZodString;
        deploymentId: z.ZodNullable<z.ZodString>;
        devmode: z.ZodBoolean;
        pending: z.ZodBoolean;
        success: z.ZodBoolean;
        error: z.ZodNullable<z.ZodString>;
        result: z.ZodNullable<z.ZodAny>;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type EvalRunDetail = z.infer<typeof EvalRunDetailSchema>;
export declare function evalRunGet(client: APIClient, id: string): Promise<EvalRunDetail>;
//# sourceMappingURL=run-get.d.ts.map