import { z } from 'zod';
import { APIClient } from '../api.ts';
export declare const APIKeyDetailSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    orgId: z.ZodString;
    type: z.ZodString;
    expiresAt: z.ZodNullable<z.ZodString>;
    lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export declare const APIKeyGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        orgId: z.ZodString;
        type: z.ZodString;
        expiresAt: z.ZodNullable<z.ZodString>;
        lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        createdAt: z.ZodString;
        project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type APIKeyDetail = z.infer<typeof APIKeyDetailSchema>;
/**
 * Get a specific API key by id
 *
 * @param client
 * @param id the API key id
 * @returns
 */
export declare function apikeyGet(client: APIClient, id: string): Promise<APIKeyDetail>;
//# sourceMappingURL=get.d.ts.map