import type { Schema, Infer } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema for validating records (objects with string keys and typed values).
 * Like TypeScript's Record<string, T> type.
 *
 * @template K - The key schema (must be string)
 * @template V - The value schema
 *
 * @example
 * ```typescript
 * const schema = s.record(s.string(), s.number());
 * schema.parse({ a: 1, b: 2 }); // { a: 1, b: 2 }
 * schema.parse({ a: 'invalid' }); // throws ValidationError
 * ```
 */
export declare class RecordSchema<K extends Schema<string, string>, V extends Schema<any, any>> implements Schema<Record<Infer<K>, Infer<V>>, Record<Infer<K>, Infer<V>>> {
    private keySchema;
    private valueSchema;
    readonly [SCHEMA_KIND] = "RecordSchema";
    description?: string;
    private recordParseMethods;
    constructor(keySchema: K, valueSchema: V);
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<Record<Infer<K>, Infer<V>>>;
        types: {
            input: Record<Infer<K>, Infer<V>>;
            output: Record<Infer<K>, Infer<V>>;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, Record<Infer<K>, Infer<V>>>, value: unknown) => Record<Infer<K>, Infer<V>>;
    safeParse: (this: Schema<any, Record<Infer<K>, Infer<V>>>, value: unknown) => import("../base.ts").SafeParseResult<Record<Infer<K>, Infer<V>>>;
}
/**
 * Create a record schema for objects with string keys and typed values.
 *
 * @param keySchema - Schema for keys (typically s.string())
 * @param valueSchema - Schema for values
 *
 * @example
 * ```typescript
 * const configSchema = s.record(s.string(), s.number());
 * const config = configSchema.parse({ timeout: 30, retries: 3 });
 *
 * const metadataSchema = s.record(s.string(), s.unknown());
 * const metadata = metadataSchema.parse({ any: 'data', here: 123 });
 * ```
 */
export declare function record<K extends Schema<string, string>, V extends Schema<any, any>>(keySchema: K, valueSchema: V): RecordSchema<K, V>;
//# sourceMappingURL=record.d.ts.map