/**
 * A composite implementation of SessionEventProvider that forwards events to multiple providers
 */
export class CompositeSessionEventProvider {
    providers;
    constructor(...providers) {
        this.providers = providers;
    }
    /**
     * called when the session starts
     *
     * @param event SessionStartEvent
     */
    async start(event) {
        await Promise.all(this.providers.map((p) => p.start(event)));
    }
    /**
     * called when the session completes
     *
     * @param event SessionCompleteEvent
     */
    async complete(event) {
        await Promise.all(this.providers.map((p) => p.complete(event)));
    }
}
//# sourceMappingURL=composite.js.map