/**
 * Runtime dev patches — replaces build-time Bun.build patches for dev mode.
 *
 * When --experimental-no-bundle is used, the generated entry file (src/generated/app.ts)
 * is run directly by Bun without bundling. These runtime patches apply the same
 * monkey-patches that would normally be injected by the Bun.build plugin during bundling.
 *
 * Three categories of patches:
 * 1. Gateway: Set env vars to route LLM calls through Agentuity AI Gateway
 * 2. AI SDK: Wrap Vercel AI SDK functions with telemetry + gateway config
 * 3. OTel LLM: Wrap LLM SDK .create() methods with OpenTelemetry spans
 */
/**
 * Apply all runtime dev patches.
 *
 * Must be called:
 * - AFTER bootstrapRuntimeEnv() (so env vars like AGENTUITY_SDK_KEY are loaded)
 * - BEFORE any user code imports LLM SDKs
 */
export declare function applyDevPatches(): Promise<void>;
//# sourceMappingURL=index.d.ts.map