import type { HubAction } from './protocol.ts';
export interface ActionResult {
    block?: {
        block: true;
        reason: string;
    };
    returnValue?: unknown;
}
/** Minimal UI surface used by action handlers — avoids a hard dep on pi-coding-agent. */
interface ActionContext {
    ui?: {
        notify(message: string, level?: 'info' | 'warning' | 'error'): void;
        confirm(title: string, message: string): Promise<boolean>;
        setStatus(key: string, text?: string): void;
    };
}
export declare function processActions(actions: HubAction[], ctx: ActionContext): Promise<ActionResult>;
export {};
//# sourceMappingURL=handlers.d.ts.map