import { FetchAdapter } from './adapter.ts';
export interface Webhook {
    id: string;
    created_at: string;
    updated_at: string;
    created_by: string;
    name: string;
    description: string | null;
    url: string;
}
export interface WebhookDestination {
    id: string;
    webhook_id: string;
    created_at: string;
    updated_at: string;
    created_by: string;
    type: string;
    config: Record<string, unknown>;
}
export interface WebhookReceipt {
    id: string;
    date: string;
    webhook_id: string;
    headers: Record<string, string>;
    payload: unknown;
}
export interface WebhookDelivery {
    id: string;
    date: string;
    webhook_id: string;
    webhook_destination_id: string;
    webhook_receipt_id: string;
    status: 'pending' | 'success' | 'failed';
    retries: number;
    error: string | null;
    response: Record<string, unknown> | null;
}
export interface CreateWebhookParams {
    name: string;
    description?: string;
}
export interface UpdateWebhookParams {
    name?: string;
    description?: string;
}
export interface CreateWebhookDestinationParams {
    type: string;
    config: Record<string, unknown>;
}
export interface WebhookListResult {
    webhooks: Webhook[];
    total: number;
}
export interface WebhookGetResult {
    webhook: Webhook;
    destinations: WebhookDestination[];
}
export interface WebhookCreateResult {
    webhook: Webhook;
}
export interface UpdateWebhookResult {
    webhook: Webhook;
}
export interface CreateDestinationResult {
    destination: WebhookDestination;
}
export interface ListDestinationsResult {
    destinations: WebhookDestination[];
}
export interface WebhookReceiptListResult {
    receipts: WebhookReceipt[];
}
export interface WebhookDeliveryListResult {
    deliveries: WebhookDelivery[];
}
export declare class WebhookService {
    #private;
    constructor(baseUrl: string, adapter: FetchAdapter);
    create(params: CreateWebhookParams): Promise<WebhookCreateResult>;
    list(params?: {
        limit?: number;
        offset?: number;
    }): Promise<WebhookListResult>;
    get(webhookId: string): Promise<WebhookGetResult>;
    update(webhookId: string, params: UpdateWebhookParams): Promise<UpdateWebhookResult>;
    delete(webhookId: string): Promise<void>;
    createDestination(webhookId: string, params: CreateWebhookDestinationParams): Promise<CreateDestinationResult>;
    listDestinations(webhookId: string): Promise<ListDestinationsResult>;
    deleteDestination(webhookId: string, destinationId: string): Promise<void>;
    listReceipts(webhookId: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<WebhookReceiptListResult>;
    getReceipt(webhookId: string, receiptId: string): Promise<WebhookReceipt>;
    listDeliveries(webhookId: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<WebhookDeliveryListResult>;
    retryDelivery(webhookId: string, deliveryId: string): Promise<void>;
}
//# sourceMappingURL=webhook.d.ts.map