import type { Logger } from '@agentuity/core';
import { projectGet, projectCreate, projectEnvUpdate, listOrganizations } from '@agentuity/server';
import type { APIClient } from '../../api';
import type { AuthData, Config, Project } from '../../types';
import { loadProjectConfig, createProjectConfig } from '../../config';
import * as tui from '../../tui';
import { isTTY } from '../../auth';
export interface ReconcileResult {
    status: 'valid' | 'imported' | 'skipped' | 'error';
    project?: Project;
    message?: string;
}
export interface ReconcileOptions {
    dir: string;
    auth: AuthData;
    apiClient: APIClient;
    config: Config;
    logger: Logger;
    interactive?: boolean;
    /** If true, skip prompts and just validate */
    validateOnly?: boolean;
}
/**
 * Dependencies that can be injected for testing
 */
export interface ReconcileDeps {
    projectGet: typeof projectGet;
    projectCreate: typeof projectCreate;
    projectEnvUpdate: typeof projectEnvUpdate;
    listOrganizations: typeof listOrganizations;
    loadProjectConfig: typeof loadProjectConfig;
    createProjectConfig: typeof createProjectConfig;
    isTTY: typeof isTTY;
    confirm: typeof tui.confirm;
    selectOrganization: typeof tui.selectOrganization;
}
/**
 * Try to load project config, returning null if not found or invalid
 * @internal Exported for testing
 */
export declare function tryLoadProjectConfig(dir: string, config: Config | null, deps?: Pick<ReconcileDeps, 'loadProjectConfig'>): Promise<Project | null>;
/**
 * Get the default project name from package.json or directory name
 * @internal Exported for testing
 */
export declare function getDefaultProjectName(dir: string): Promise<string>;
/**
 * Check if a directory contains a valid Agentuity project structure
 * @internal Exported for testing
 */
export declare function isValidProjectStructure(dir: string): Promise<boolean>;
/**
 * Reconcile a project - validate access or import if needed
 *
 * This function checks if the current directory has a valid agentuity.json
 * and if the user has access to the project. If not, it offers to import
 * the project to the user's organization.
 *
 * For directories without agentuity.json, it validates the project structure
 * and offers to register the project with Agentuity Cloud.
 */
export declare function reconcileProject(opts: ReconcileOptions): Promise<ReconcileResult>;
/**
 * Run project import directly (for the import command)
 */
export declare function runProjectImport(opts: ReconcileOptions): Promise<ReconcileResult>;
//# sourceMappingURL=reconcile.d.ts.map