import type { APIClient } from '../../api';
export interface GithubInstallation {
    installationId: string;
    integrationId?: string;
    accountName: string;
    accountType: 'User' | 'Organization';
    avatarUrl?: string;
}
export interface GithubIntegrationStartResult {
    shortId: string;
    hasIdentity: boolean;
}
export interface GithubIntegrationStatusResult {
    connected: boolean;
    identity: {
        githubUsername: string;
        githubEmail?: string;
        avatarUrl?: string;
    } | null;
    installations: GithubInstallation[];
}
export declare function startGithubIntegration(apiClient: APIClient): Promise<GithubIntegrationStartResult>;
export declare function getGithubIntegrationStatus(apiClient: APIClient): Promise<GithubIntegrationStatusResult>;
export interface GithubDisconnectResult {
    disconnected: boolean;
}
export declare function disconnectGithubIntegration(apiClient: APIClient, installationId?: string): Promise<GithubDisconnectResult>;
export declare function pollForGithubIntegration(apiClient: APIClient, initialCount: number, timeoutMs?: number): Promise<GithubIntegrationStatusResult>;
export interface GithubRepo {
    id: number;
    name: string;
    fullName: string;
    private: boolean;
    defaultBranch: string;
    integrationId: string;
}
export declare function listGithubRepos(apiClient: APIClient, integrationId?: string): Promise<GithubRepo[]>;
export interface LinkProjectOptions {
    projectId: string;
    repoFullName: string;
    branch: string;
    autoDeploy: boolean;
    previewDeploy: boolean;
    directory?: string;
}
export declare function linkProjectToRepo(apiClient: APIClient, options: LinkProjectOptions): Promise<boolean>;
export declare function unlinkProjectFromRepo(apiClient: APIClient, projectId: string): Promise<boolean>;
export interface ProjectGithubStatus {
    linked: boolean;
    repoFullName?: string;
    branch?: string;
    autoDeploy?: boolean;
    previewDeploy?: boolean;
    directory?: string;
}
export declare function getProjectGithubStatus(apiClient: APIClient, projectId: string): Promise<ProjectGithubStatus>;
//# sourceMappingURL=api.d.ts.map