/**
 * Get cached user info for a profile.
 * Returns null if not found in cache.
 */
export declare function getCachedUserInfo(profile: string): {
    userId: string;
    firstName: string;
    lastName: string;
} | null;
/**
 * Cache user info for a profile.
 * Upserts the entry so repeated calls are safe.
 */
export declare function setCachedUserInfo(profile: string, userId: string, firstName: string, lastName: string): void;
/**
 * Clear cached user info for a profile.
 * Called on logout to ensure stale data is removed.
 */
export declare function clearCachedUserInfo(profile: string): void;
//# sourceMappingURL=user-cache.d.ts.map