import type { WorkbenchConfig } from '@agentuity/core/workbench';
import type React from 'react';
import type { WorkbenchContextType } from '../../types/config';
export declare function useWorkbench(): WorkbenchContextType;
/**
 * Callback to get authentication headers for workbench requests.
 * Called before each API request with the request body.
 * Should return headers like X-Agentuity-Workbench-Signature and X-Agentuity-Workbench-Timestamp.
 */
export type GetAuthHeaders = (body: string) => Promise<Record<string, string>>;
interface WorkbenchProviderProps {
    config: Omit<WorkbenchConfig, 'route'> & {
        baseUrl?: string | null;
        projectId?: string;
    };
    env: {
        agentuity: boolean;
        authenticated: boolean;
        cloud: boolean;
    };
    children: React.ReactNode;
    portals?: {
        actionBar?: {
            pre?: React.ReactNode;
            post?: React.ReactNode;
        };
    };
    /**
     * Optional callback to get authentication headers for requests to deployed agents.
     * Called before each API request with the request body (empty string for GET/DELETE).
     * Useful for signature-based authentication in production deployments.
     */
    getAuthHeaders?: GetAuthHeaders;
}
export declare function WorkbenchProvider({ config, env, children, portals, getAuthHeaders, }: WorkbenchProviderProps): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=workbench-provider.d.ts.map