import { z } from 'zod';
import { APIResponseSchemaNoData } from "../api.js";
import { ProjectResponseError } from "./util.js";
export const ProjectEnvDeleteRequestSchema = z
    .object({
    id: z.string().describe('the project id'),
    env: z.array(z.string()).optional().describe('environment variable keys to delete'),
    secrets: z.array(z.string()).optional().describe('secret keys to delete'),
})
    .refine((data) => (data.env?.length ?? 0) > 0 || (data.secrets?.length ?? 0) > 0, {
    message: 'must provide at least one of env or secrets',
});
export const ProjectEnvDeleteResponseSchema = APIResponseSchemaNoData();
/**
 * Delete environment variables and/or secrets from a project.
 * Provide arrays of keys to delete.
 */
export async function projectEnvDelete(client, request) {
    const { id, env, secrets } = request;
    const resp = await client.request('DELETE', `/cli/project/${id}/env`, ProjectEnvDeleteResponseSchema, {
        env,
        secrets,
    });
    if (!resp.success) {
        throw new ProjectResponseError({ message: resp.message ?? 'failed to delete project env' });
    }
    // Delete operations don't return data, success is sufficient
}
//# sourceMappingURL=env-delete.js.map