/**
 * Runtime LLM Gateway patches for dev mode.
 *
 * Replaces the build-time patches from cli/src/cmd/build/patch/llm.ts.
 * Sets environment variables to route LLM SDK calls through the Agentuity AI Gateway
 * when the user hasn't provided their own API keys.
 */
/**
 * Set environment variables to route LLM calls through the AI Gateway.
 *
 * For each provider, if the user hasn't set their own API key (or it equals
 * the SDK key), we redirect to the gateway. This matches the behavior of
 * the build-time patches in patch/llm.ts.
 */
export declare function applyGatewayPatches(): void;
//# sourceMappingURL=gateway.d.ts.map