import { z } from 'zod';
export declare const EvalRunStartEventSchema: z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodString;
    orgId: z.ZodString;
    projectId: z.ZodString;
    devmode: z.ZodBoolean;
    deploymentId: z.ZodOptional<z.ZodString>;
    spanId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type EvalRunStartEvent = z.infer<typeof EvalRunStartEventSchema>;
export declare const EvalRunCompleteEventSchema: z.ZodObject<{
    id: z.ZodString;
    error: z.ZodOptional<z.ZodString>;
    result: z.ZodOptional<z.ZodAny>;
}, z.core.$strip>;
export type EvalRunCompleteEvent = z.infer<typeof EvalRunCompleteEventSchema>;
export declare const EvalRunStartEventDelayedSchema: z.ZodIntersection<z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodString;
    orgId: z.ZodString;
    projectId: z.ZodString;
    devmode: z.ZodBoolean;
    deploymentId: z.ZodOptional<z.ZodString>;
    spanId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    timestamp: z.ZodNumber;
}, z.core.$strip>>;
export declare const EvalRunCompleteEventDelayedSchema: z.ZodIntersection<z.ZodObject<{
    id: z.ZodString;
    error: z.ZodOptional<z.ZodString>;
    result: z.ZodOptional<z.ZodAny>;
}, z.core.$strip>, z.ZodObject<{
    timestamp: z.ZodNumber;
}, z.core.$strip>>;
/**
 * EvalRunEventProvider is a provider for logging and tracking agent evaluation run lifecycle events.
 * Eval runs represent test executions of agents for quality assurance and performance monitoring.
 */
export interface EvalRunEventProvider {
    /**
     * Called when an agent evaluation run starts. Records the initial context including
     * the evaluation ID, associated session, and organization/project metadata.
     *
     * @param event - EvalRunStartEvent containing evaluation initialization data
     *
     * @example
     * ```typescript
     * await evalProvider.start({
     *   id: 'evalrun_abc123',
     *   sessionId: 'sess_abc123',
     *   evalId: 'evalid_abc123',
     *   evalIdentifier: 'eval_abc123',
     *   orgId: 'org_456',
     *   projectId: 'proj_789',
     *   devmode: true
     * });
     * ```
     */
    start(event: EvalRunStartEvent): Promise<void>;
    /**
     * Called when an agent evaluation run completes (successfully or with error).
     * Records final results, metrics, and any errors encountered during evaluation.
     *
     * @param event - EvalRunCompleteEvent containing evaluation results and status
     *
     * @example
     * ```typescript
     * // Successful evaluation completion
     * await evalProvider.complete({
     *   id: 'eval-run-123',
     *   result: {
     *     passed: true,
     *     score: 0.95,
     *     metrics: { latency: 250, accuracy: 0.98 }
     *   }
     * });
     *
     * // Evaluation with error
     * await evalProvider.complete({
     *   id: 'eval-run-123',
     *   error: 'Agent timeout after 30 seconds',
     *   result: { passed: false }
     * });
     * ```
     */
    complete(event: EvalRunCompleteEvent): Promise<void>;
}
//# sourceMappingURL=evalrun.d.ts.map