import { TaskStorageService, type Logger } from '@agentuity/core';
import type { AuthData, Config, GlobalOptions } from '../../../types';
export interface TaskContext {
    logger: Logger;
    auth: AuthData;
    config: Config | null;
    options: GlobalOptions;
}
export declare function createStorageAdapter(ctx: TaskContext): Promise<TaskStorageService>;
export declare function cacheTaskId(ctx: {
    config: Config | null;
    options: GlobalOptions;
}, taskId: string): Promise<void>;
export declare function parseMetadataFlag(raw: string | undefined): Record<string, unknown> | undefined;
//# sourceMappingURL=util.d.ts.map