/**
 * Vite-native entry file generator (v2 - clean architecture)
 * Single source for both dev and prod with minimal differences
 */
import type { Logger, WorkbenchConfig, AnalyticsConfig } from '../../types';
import { discoverRoutes } from './vite/route-discovery';
interface GenerateEntryOptions {
    rootDir: string;
    projectId: string;
    deploymentId: string;
    logger: Logger;
    mode: 'dev' | 'prod';
    workbench?: WorkbenchConfig;
    analytics?: boolean | AnalyticsConfig;
    vitePort?: number;
    noBundle?: boolean;
    /** Pre-discovered routes to avoid redundant route discovery */
    preDiscoveredRoutes?: Awaited<ReturnType<typeof discoverRoutes>>['routeInfoList'];
}
/**
 * Generate entry file with clean Vite-native architecture
 */
export declare function generateEntryFile(options: GenerateEntryOptions): Promise<void>;
export {};
//# sourceMappingURL=entry-generator.d.ts.map