/**
 * AI Help Generator - dashdash specification implementation
 *
 * Generates AI-optimized help output in dashdash format (https://github.com/visionik/dashdash)
 * for improved discoverability and usability by AI agents.
 */
import type { CLISchema } from './schema-generator';
export interface DashdashConfig {
    name: string;
    description: string;
    accessLevel: 'read' | 'browse' | 'interact' | 'full';
    webUrl: string;
    apiUrl: string;
    docsUrl: string;
    mcpUrl?: string;
    homepage: string;
    repository: string;
}
/**
 * Generate dashdash-compliant AI help output
 */
export declare function generateAIHelp(schema: CLISchema, config?: DashdashConfig): string;
//# sourceMappingURL=ai-help.d.ts.map