/**
 * @agentuity/claude-code - Agentuity Coder plugin for Claude Code
 *
 * Install script that configures the plugin for the current project.
 * Sets up permissions for Agentuity Cloud CLI commands.
 */
export interface InstallConfig {
    projectId?: string;
    orgId?: string;
    region?: string;
}
/**
 * Read agentuity.json from the current project if it exists.
 */
export declare function readProjectConfig(): Promise<InstallConfig>;
/**
 * Install the Agentuity Coder plugin.
 * This is called when the plugin is first installed.
 */
export declare function install(): Promise<void>;
export default install;
//# sourceMappingURL=install.d.ts.map