export interface ServiceUrls {
    keyvalue: string;
    stream: string;
    vector: string;
    catalyst: string;
    otel: string;
    sandbox: string;
    email: string;
}
/**
 * Resolve the region from the provided value or AGENTUITY_REGION environment variable.
 * Throws an error if no region can be resolved.
 */
export declare function resolveRegion(region?: string): string;
/**
 * Get service URLs from environment variables with fallback defaults.
 * Throws an error if region cannot be resolved (neither passed as parameter nor set via AGENTUITY_REGION).
 */
export declare function getServiceUrls(region?: string): ServiceUrls;
//# sourceMappingURL=config.d.ts.map