import { z } from 'zod';
import { type APIClient } from '../api.ts';
import { type ListWebhookReceiptsRequest, type WebhookApiOptions, type WebhookReceipt } from './types.ts';
export declare const WebhookReceiptResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        date: z.ZodString;
        webhook_id: z.ZodString;
        headers: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        payload: z.ZodUnknown;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const WebhookReceiptsListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        date: z.ZodString;
        webhook_id: z.ZodString;
        headers: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        payload: z.ZodUnknown;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
/**
 * List receipts for a webhook with optional pagination.
 *
 * Receipts represent incoming webhook payloads that were received.
 *
 * @param client - The API client instance
 * @param webhookId - The webhook ID (prefixed with wh_)
 * @param params - Optional pagination parameters
 * @param options - Optional API options (e.g., orgId)
 * @returns Object containing the list of receipts
 * @throws {WebhookNotFoundError} If the webhook does not exist
 * @throws {WebhookError} If the API request fails
 *
 * @example
 * ```typescript
 * const { receipts } = await listWebhookReceipts(client, 'wh_abc123', { limit: 10 });
 * for (const receipt of receipts) {
 *   console.log(`Receipt ${receipt.id}: received at ${receipt.date}`);
 * }
 * ```
 */
export declare function listWebhookReceipts(client: APIClient, webhookId: string, params?: ListWebhookReceiptsRequest, options?: WebhookApiOptions): Promise<{
    receipts: WebhookReceipt[];
}>;
/**
 * Get a specific receipt for a webhook.
 *
 * Retrieves the full receipt details including headers and payload.
 *
 * @param client - The API client instance
 * @param webhookId - The webhook ID (prefixed with wh_)
 * @param receiptId - The receipt ID (prefixed with whrc_)
 * @param options - Optional API options (e.g., orgId)
 * @returns The receipt details
 * @throws {WebhookReceiptNotFoundError} If the receipt does not exist
 * @throws {WebhookNotFoundError} If the webhook does not exist
 * @throws {WebhookError} If the API request fails
 *
 * @example
 * ```typescript
 * const receipt = await getWebhookReceipt(client, 'wh_abc123', 'whrc_def456');
 * console.log(`Receipt payload:`, receipt.payload);
 * ```
 */
export declare function getWebhookReceipt(client: APIClient, webhookId: string, receiptId: string, options?: WebhookApiOptions): Promise<WebhookReceipt>;
//# sourceMappingURL=receipts.d.ts.map