import type { z } from 'zod';
import { type APIClient } from '../api';
export declare const ResumeResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export interface SandboxResumeParams {
    sandboxId: string;
    orgId?: string;
}
/**
 * Resumes a paused sandbox from its checkpoint.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID to resume
 * @throws {SandboxResponseError} If the sandbox is not found or resume fails
 */
export declare function sandboxResume(client: APIClient, params: SandboxResumeParams): Promise<void>;
//# sourceMappingURL=resume.d.ts.map