import type { z } from 'zod';
import { type APIClient } from '../api';
export declare const PauseResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export interface SandboxPauseParams {
    sandboxId: string;
    orgId?: string;
}
/**
 * Pauses a running sandbox, creating a checkpoint of its current state.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID to pause
 * @throws {SandboxResponseError} If the sandbox is not found or pause fails
 */
export declare function sandboxPause(client: APIClient, params: SandboxPauseParams): Promise<void>;
//# sourceMappingURL=pause.d.ts.map