import { z } from 'zod';
import { APIClient } from '../api.ts';
export declare const ListRegionsResponse: z.ZodArray<z.ZodObject<{
    region: z.ZodString;
    description: z.ZodString;
}, z.core.$strip>>;
export declare const ListRegionsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        region: z.ZodString;
        description: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type ListRegionsResponse = z.infer<typeof ListRegionsResponseSchema>;
export type RegionList = z.infer<typeof ListRegionsResponse>;
/**
 * List all available cloud regions
 *
 * @param client
 * @returns
 */
export declare function listRegions(client: APIClient): Promise<RegionList>;
//# sourceMappingURL=list.d.ts.map