import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema for validating undefined values.
 */
export declare class UndefinedSchema implements Schema<undefined, undefined> {
    readonly [SCHEMA_KIND] = "UndefinedSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<undefined>;
        types: {
            input: undefined;
            output: undefined;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, undefined>, value: unknown) => undefined;
    safeParse: (this: Schema<any, undefined>, value: unknown) => import("../base.ts").SafeParseResult<undefined>;
}
/**
 * Create an undefined schema.
 */
export declare function undefined_(): UndefinedSchema;
//# sourceMappingURL=undefined.d.ts.map