import { createIssue, failure, success, createParseMethods, SCHEMA_KIND } from "../base.js";
import { optional } from "../utils/optional.js";
import { nullable } from "../utils/nullable.js";
const parseMethods = createParseMethods();
/**
 * Schema for validating boolean values.
 *
 * @example
 * ```typescript
 * const schema = s.boolean();
 * const active = schema.parse(true); // true
 * schema.parse('true'); // throws ValidationError
 * ```
 */
export class BooleanSchema {
    [SCHEMA_KIND] = 'BooleanSchema';
    description;
    '~standard' = {
        version: 1,
        vendor: 'agentuity',
        validate: (value) => {
            if (typeof value !== 'boolean') {
                return failure([createIssue(`Expected boolean, got ${typeof value}`)]);
            }
            return success(value);
        },
        types: undefined,
    };
    describe(description) {
        this.description = description;
        return this;
    }
    optional() {
        return optional(this);
    }
    nullable() {
        return nullable(this);
    }
    parse = parseMethods.parse;
    safeParse = parseMethods.safeParse;
}
/**
 * Create a boolean schema.
 *
 * @example
 * ```typescript
 * const activeSchema = s.boolean().describe('Account status');
 * const active = activeSchema.parse(true);
 * ```
 */
export function boolean() {
    return new BooleanSchema();
}
//# sourceMappingURL=boolean.js.map