import type { Schema, Infer } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema for validating arrays with typed elements.
 * Validates each element and collects all validation errors with array indices in paths.
 *
 * @template T - The schema type for array elements
 *
 * @example
 * ```typescript
 * const tagsSchema = s.array(s.string());
 * const tags = tagsSchema.parse(['tag1', 'tag2']);
 *
 * const usersSchema = s.array(s.object({
 *   name: s.string(),
 *   age: s.number()
 * }));
 * ```
 */
export declare class ArraySchema<T extends Schema<any, any>> implements Schema<Array<Infer<T>>, Array<Infer<T>>> {
    private itemSchema;
    readonly [SCHEMA_KIND] = "ArraySchema";
    description?: string;
    private parseMethods;
    constructor(itemSchema: T);
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<Infer<T>[]>;
        types: {
            input: Array<Infer<T>>;
            output: Array<Infer<T>>;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, Infer<T>[]>, value: unknown) => Infer<T>[];
    safeParse: (this: Schema<any, Infer<T>[]>, value: unknown) => import("../base.ts").SafeParseResult<Infer<T>[]>;
}
/**
 * Create an array schema with typed elements.
 *
 * @param itemSchema - The schema for validating each array element
 *
 * @example
 * ```typescript
 * const stringArray = s.array(s.string());
 * const tags = stringArray.parse(['tag1', 'tag2']);
 *
 * const userArray = s.array(s.object({
 *   name: s.string(),
 *   age: s.number()
 * }));
 * ```
 */
export declare function array<T extends Schema<any, any>>(itemSchema: T): ArraySchema<T>;
//# sourceMappingURL=array.d.ts.map