import { success, createParseMethods, SCHEMA_KIND } from "../base.js";
import { optional } from "../utils/optional.js";
import { nullable } from "../utils/nullable.js";
const parseMethods = createParseMethods();
/**
 * Schema that coerces any value to a string using String(value).
 *
 * @example
 * ```typescript
 * const schema = s.coerce.string();
 * schema.parse(123); // '123'
 * schema.parse(true); // 'true'
 * schema.parse(null); // 'null'
 * ```
 */
export class CoerceStringSchema {
    [SCHEMA_KIND] = 'CoerceStringSchema';
    description;
    '~standard' = {
        version: 1,
        vendor: 'agentuity',
        validate: (value) => {
            // Coerce to string
            return success(String(value));
        },
        types: undefined,
    };
    describe(description) {
        this.description = description;
        return this;
    }
    optional() {
        return optional(this);
    }
    nullable() {
        return nullable(this);
    }
    parse = parseMethods.parse;
    safeParse = parseMethods.safeParse;
}
/**
 * Create a schema that coerces values to strings.
 * Useful for parsing form data or query parameters.
 */
export function coerceString() {
    return new CoerceStringSchema();
}
//# sourceMappingURL=string.js.map