import type { Schema } from '../base.ts';
import { SCHEMA_KIND } from '../base.ts';
/**
 * Schema that coerces values to booleans using Boolean(value).
 * Uses JavaScript truthy/falsy rules.
 *
 * @example
 * ```typescript
 * const schema = s.coerce.boolean();
 * schema.parse(1); // true
 * schema.parse(0); // false
 * schema.parse(''); // false
 * schema.parse('hello'); // true
 * ```
 */
export declare class CoerceBooleanSchema implements Schema<unknown, boolean> {
    readonly [SCHEMA_KIND] = "CoerceBooleanSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.SuccessResult<boolean>;
        types: {
            input: unknown;
            output: boolean;
        };
    };
    describe(description: string): this;
    optional(): import("../index.ts").OptionalSchema<this>;
    nullable(): import("../index.ts").NullableSchema<this>;
    parse: (this: Schema<any, boolean>, value: unknown) => boolean;
    safeParse: (this: Schema<any, boolean>, value: unknown) => import("../base.ts").SafeParseResult<boolean>;
}
/**
 * Create a schema that coerces values to booleans.
 * Useful for parsing checkboxes or boolean flags from strings.
 */
export declare function coerceBoolean(): CoerceBooleanSchema;
//# sourceMappingURL=boolean.d.ts.map