import type { Database } from 'bun:sqlite';
import type { TaskStorage, Task, CreateTaskParams, UpdateTaskParams, ListTasksParams, ListTasksResult, TaskChangelogResult, Comment, Tag, ListCommentsResult, ListTagsResult, ListUsersResult, ListProjectsResult, Attachment, CreateAttachmentParams, PresignUploadResponse, PresignDownloadResponse, ListAttachmentsResult, TaskActivityParams, TaskActivityResult } from '@agentuity/core';
export declare class LocalTaskStorage implements TaskStorage {
    #private;
    constructor(db: Database, projectPath: string);
    create(params: CreateTaskParams): Promise<Task>;
    get(id: string): Promise<Task | null>;
    list(params?: ListTasksParams): Promise<ListTasksResult>;
    update(id: string, params: UpdateTaskParams): Promise<Task>;
    close(id: string): Promise<Task>;
    changelog(id: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<TaskChangelogResult>;
    softDelete(id: string): Promise<Task>;
    createComment(taskId: string, body: string, userId: string): Promise<Comment>;
    getComment(commentId: string): Promise<Comment>;
    updateComment(commentId: string, body: string): Promise<Comment>;
    deleteComment(commentId: string): Promise<void>;
    listComments(taskId: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<ListCommentsResult>;
    createTag(name: string, color?: string): Promise<Tag>;
    getTag(tagId: string): Promise<Tag>;
    updateTag(tagId: string, name: string, color?: string): Promise<Tag>;
    deleteTag(tagId: string): Promise<void>;
    listTags(): Promise<ListTagsResult>;
    addTagToTask(taskId: string, tagId: string): Promise<void>;
    removeTagFromTask(taskId: string, tagId: string): Promise<void>;
    listTagsForTask(taskId: string): Promise<Tag[]>;
    uploadAttachment(_taskId: string, _params: CreateAttachmentParams): Promise<PresignUploadResponse>;
    confirmAttachment(_attachmentId: string): Promise<Attachment>;
    downloadAttachment(_attachmentId: string): Promise<PresignDownloadResponse>;
    listAttachments(_taskId: string): Promise<ListAttachmentsResult>;
    deleteAttachment(_attachmentId: string): Promise<void>;
    listUsers(): Promise<ListUsersResult>;
    listProjects(): Promise<ListProjectsResult>;
    getActivity(params?: TaskActivityParams): Promise<TaskActivityResult>;
}
//# sourceMappingURL=task.d.ts.map