import { StructuredError, } from '@agentuity/core';
const ERROR_MESSAGE = 'Email service is not available in local development mode. Deploy to Agentuity Cloud to use email.';
const LocalEmailNotAvailableError = StructuredError('LocalEmailNotAvailableError', ERROR_MESSAGE);
/**
 * Local development stub for the email service.
 * All methods throw a descriptive error directing users to deploy to Agentuity Cloud.
 */
export class LocalEmailStorage {
    async createAddress(_localPart) {
        throw new LocalEmailNotAvailableError();
    }
    async listAddresses() {
        throw new LocalEmailNotAvailableError();
    }
    async getAddress(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async getConnectionConfig(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async deleteAddress(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async createDestination(_addressId, _type, _config) {
        throw new LocalEmailNotAvailableError();
    }
    async listDestinations(_addressId) {
        throw new LocalEmailNotAvailableError();
    }
    async deleteDestination(_addressId, _destinationId) {
        throw new LocalEmailNotAvailableError();
    }
    async send(_params) {
        throw new LocalEmailNotAvailableError();
    }
    async listInbound(_addressId) {
        throw new LocalEmailNotAvailableError();
    }
    async getInbound(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async deleteInbound(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async listOutbound(_addressId) {
        throw new LocalEmailNotAvailableError();
    }
    async getOutbound(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async deleteOutbound(_id) {
        throw new LocalEmailNotAvailableError();
    }
    async getActivity(_params) {
        throw new LocalEmailNotAvailableError();
    }
}
//# sourceMappingURL=email.js.map