/**
 * Runtime AI SDK patches for dev mode.
 *
 * Replaces the build-time patches from cli/src/cmd/build/patch/aisdk.ts.
 * Monkey-patches Vercel AI SDK functions to:
 * 1. Enable experimental telemetry on all AI function calls
 * 2. Route AI SDK provider factory functions through the AI Gateway
 */
/**
 * Patch AI SDK core functions (generateText, streamText, etc.) with telemetry injection.
 */
export declare function applyAISDKCorePatches(): Promise<void>;
/**
 * Patch AI SDK provider factory functions to route through the AI Gateway.
 */
export declare function applyAISDKProviderPatches(): Promise<void>;
//# sourceMappingURL=aisdk.d.ts.map