export declare const WorkbenchConfigError: {
    new (args?: {
        cause?: unknown;
    } | undefined): import("./error.ts").RichError & {
        readonly _tag: "WorkbenchConfigError";
    } & Readonly<Record<string, never>>;
    readonly defaultMessage?: string;
} & (<Shape extends {
    [x: string]: any;
} = Record<string, never>>() => {
    new (args?: (Shape extends Record<string, never> ? {
        cause?: unknown;
    } : Shape & {
        cause?: unknown;
    }) | undefined): import("./error.ts").RichError & {
        readonly _tag: "WorkbenchConfigError";
    } & Readonly<Shape>;
    readonly defaultMessage?: string;
});
export declare const WorkbenchNotFoundError: {
    new (args?: {
        cause?: unknown;
    } | undefined): import("./error.ts").RichError & {
        readonly _tag: "WorkbenchNotFoundError";
    } & Readonly<Record<string, never>>;
    readonly defaultMessage?: string;
} & (<Shape extends {
    [x: string]: any;
} = Record<string, never>>() => {
    new (args?: (Shape extends Record<string, never> ? {
        cause?: unknown;
    } : Shape & {
        cause?: unknown;
    }) | undefined): import("./error.ts").RichError & {
        readonly _tag: "WorkbenchNotFoundError";
    } & Readonly<Shape>;
    readonly defaultMessage?: string;
});
/**
 * Workbench configuration utilities shared across packages
 */
export interface WorkbenchConfig {
    route?: string;
    headers?: Record<string, string>;
    apiKey?: string;
    baseUrl?: string | null;
}
/**
 * Encode workbench config to base64 for environment variable storage
 */
export declare function encodeWorkbenchConfig(config: WorkbenchConfig): string;
/**
 * Decode workbench config from base64 environment variable
 * Throws error if config is invalid
 */
export declare function decodeWorkbenchConfig(encoded: string): WorkbenchConfig;
/**
 * Get workbench config from build-time variable
 * Throws error if config is not available or invalid
 */
export declare function getWorkbenchConfig(): WorkbenchConfig;
//# sourceMappingURL=workbench-config.d.ts.map