interface BoxOptions {
    title?: string;
    content: string;
    titleAlign?: 'left' | 'center' | 'right';
    contentAlign?: 'left' | 'center' | 'right';
    width?: number;
    padding?: number;
    withGuide?: boolean;
}
/**
 * Draw a boxed message (like clack's note)
 */
export declare function drawBox(options: BoxOptions): string;
/**
 * Render a note box (matches clack style)
 */
export declare function note(message: string, title?: string): void;
/**
 * Draw an error box with red border
 * @param withGuide - If true (default), shows guide bar at top and connector at bottom for use in flows.
 *                    If false, renders as a standalone box with proper corners.
 */
export declare function errorBox(title: string, message: string, withGuide?: boolean): void;
/**
 * Draw a warning box with yellow border
 */
export declare function warningBox(title: string, message: string): void;
export {};
//# sourceMappingURL=box.d.ts.map