/**
 * Vite Asset Server Configuration
 *
 * Minimal Vite config for serving frontend assets with HMR only.
 * Does NOT handle API routes, workbench, or WebSocket - that's the Bun server's job.
 */
import type { InlineConfig } from 'vite';
import type { Logger } from '../../../types';
export interface GenerateAssetServerConfigOptions {
    rootDir: string;
    logger: Logger;
    workbenchPath?: string;
    port: number;
}
/**
 * Generate Vite config for asset-only server (HMR + React transformation)
 */
export declare function generateAssetServerConfig(options: GenerateAssetServerConfigOptions): Promise<InlineConfig>;
//# sourceMappingURL=vite-asset-server-config.d.ts.map