/**
 * Server bundler using Bun.build with external dependency management
 * Handles installing externals into .agentuity/node_modules for production
 */
import type { Logger } from '../../../types';
/**
 * Format a Bun build log (BuildMessage or ResolveMessage) into a readable string
 */
export declare function formatBuildLog(log: BuildMessage | ResolveMessage): string;
export interface ServerBundleOptions {
    rootDir: string;
    dev: boolean;
    logger: Logger;
}
/**
 * Install external dependencies and build server bundle
 * For production: installs externals into .agentuity/node_modules BEFORE bundling
 */
export declare function installExternalsAndBuild(options: ServerBundleOptions): Promise<void>;
//# sourceMappingURL=server-bundler.d.ts.map