/**
 * Bun Dev Server
 *
 * Runs Bun server that handles ALL app logic (HTTP + WebSocket) and proxies
 * frontend asset requests to Vite asset server for HMR support.
 */
import type { Logger } from '../../../types';
export interface BunDevServerOptions {
    rootDir: string;
    port?: number;
    projectId?: string;
    orgId?: string;
    deploymentId?: string;
    logger: Logger;
    vitePort: number;
    inspect?: boolean;
    inspectWait?: boolean;
    inspectBrk?: boolean;
    noBundle?: boolean;
}
export interface BunDevServerResult {
    bunServerPort: number;
}
/**
 * Start Bun dev server (Vite asset server must already be running)
 *
 * IMPORTANT: This function assumes that the dev bundle has already been built:
 * - Entry file generated at src/generated/app.ts (with workbench config if enabled)
 * - Bundled to .agentuity/app.js with LLM patches applied
 *
 * The bundle is loaded here to ensure AI Gateway routing patches are active.
 * Vite port is read from process.env.VITE_PORT at runtime.
 *
 * When debugger flags (inspect, inspectWait, inspectBrk) are passed, bun is spawned
 * as a subprocess to enable passing the debugger CLI flags.
 */
export declare function startBunDevServer(options: BunDevServerOptions): Promise<BunDevServerResult>;
//# sourceMappingURL=bun-dev-server.d.ts.map