import { type ClassValue } from 'clsx';
import type { ErrorInfo } from '@/types/config';
export declare function cn(...inputs: ClassValue[]): string;
/**
 * Parses the x-agentuity-tokens header string into a Record of model names to token counts.
 * Format: "model1:count1, model2:count2" or "model1:count1"
 * @param header - The x-agentuity-tokens header string
 * @returns Record mapping model names to token counts
 */
export declare function parseTokensHeader(header: string): Record<string, number>;
/**
 * Calculates the total number of tokens from a parsed tokens record.
 * @param tokens - Record mapping model names to token counts
 * @returns Total number of tokens
 */
export declare function getTotalTokens(tokens: Record<string, number>): number;
export declare const getProcessEnv: (key: string) => string | undefined;
export declare const buildUrl: (base: string, path: string, subpath?: string, query?: URLSearchParams) => string;
export declare const defaultBaseUrl: string;
export declare function generateTemplateFromSchema(schema?: unknown): string;
export declare function formatErrorForCopy(error: ErrorInfo): string;
//# sourceMappingURL=utils.d.ts.map