import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const ServiceStatsError: {
    new (args?: ({
        message: string;
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ServiceStatsError";
    } & Readonly<{
        message: string;
    }>;
    readonly defaultMessage?: string;
};
export declare const KeyValueStatSchema: z.ZodObject<{
    namespaceCount: z.ZodNumber;
    keyCount: z.ZodNumber;
    totalSizeBytes: z.ZodNumber;
}, z.core.$strip>;
export declare const VectorStatSchema: z.ZodObject<{
    namespaceCount: z.ZodNumber;
    documentCount: z.ZodNumber;
    totalSizeBytes: z.ZodNumber;
}, z.core.$strip>;
export declare const QueueStatSchema: z.ZodObject<{
    queueCount: z.ZodNumber;
    totalMessages: z.ZodNumber;
    totalDlq: z.ZodNumber;
}, z.core.$strip>;
export declare const StreamStatSchema: z.ZodObject<{
    streamCount: z.ZodNumber;
    totalSizeBytes: z.ZodNumber;
}, z.core.$strip>;
export declare const SandboxStatSchema: z.ZodObject<{
    totalActive: z.ZodNumber;
    running: z.ZodNumber;
    idle: z.ZodNumber;
    creating: z.ZodNumber;
    totalExecutions: z.ZodNumber;
    totalCpuTimeMs: z.ZodNumber;
    totalMemoryByteSec: z.ZodNumber;
    totalNetworkEgressBytes: z.ZodNumber;
}, z.core.$strip>;
export declare const EmailStatSchema: z.ZodObject<{
    addressCount: z.ZodNumber;
    inboundCount: z.ZodNumber;
    outboundCount: z.ZodNumber;
    outboundSuccess: z.ZodNumber;
    outboundFailed: z.ZodNumber;
}, z.core.$strip>;
export declare const TaskStatSchema: z.ZodObject<{
    total: z.ZodNumber;
    open: z.ZodNumber;
    inProgress: z.ZodNumber;
    closed: z.ZodNumber;
}, z.core.$strip>;
export declare const ScheduleStatSchema: z.ZodObject<{
    scheduleCount: z.ZodNumber;
    totalDeliveries: z.ZodNumber;
    successDeliveries: z.ZodNumber;
    failedDeliveries: z.ZodNumber;
}, z.core.$strip>;
export declare const DatabaseStatSchema: z.ZodObject<{
    databaseCount: z.ZodNumber;
    totalTableCount: z.ZodNumber;
    totalRecordCount: z.ZodNumber;
    totalSizeBytes: z.ZodNumber;
}, z.core.$strip>;
export declare const ServiceStatsDataSchema: z.ZodObject<{
    services: z.ZodObject<{
        database: z.ZodOptional<z.ZodObject<{
            databaseCount: z.ZodNumber;
            totalTableCount: z.ZodNumber;
            totalRecordCount: z.ZodNumber;
            totalSizeBytes: z.ZodNumber;
        }, z.core.$strip>>;
        keyvalue: z.ZodOptional<z.ZodObject<{
            namespaceCount: z.ZodNumber;
            keyCount: z.ZodNumber;
            totalSizeBytes: z.ZodNumber;
        }, z.core.$strip>>;
        vector: z.ZodOptional<z.ZodObject<{
            namespaceCount: z.ZodNumber;
            documentCount: z.ZodNumber;
            totalSizeBytes: z.ZodNumber;
        }, z.core.$strip>>;
        queue: z.ZodOptional<z.ZodObject<{
            queueCount: z.ZodNumber;
            totalMessages: z.ZodNumber;
            totalDlq: z.ZodNumber;
        }, z.core.$strip>>;
        stream: z.ZodOptional<z.ZodObject<{
            streamCount: z.ZodNumber;
            totalSizeBytes: z.ZodNumber;
        }, z.core.$strip>>;
        sandbox: z.ZodOptional<z.ZodObject<{
            totalActive: z.ZodNumber;
            running: z.ZodNumber;
            idle: z.ZodNumber;
            creating: z.ZodNumber;
            totalExecutions: z.ZodNumber;
            totalCpuTimeMs: z.ZodNumber;
            totalMemoryByteSec: z.ZodNumber;
            totalNetworkEgressBytes: z.ZodNumber;
        }, z.core.$strip>>;
        email: z.ZodOptional<z.ZodObject<{
            addressCount: z.ZodNumber;
            inboundCount: z.ZodNumber;
            outboundCount: z.ZodNumber;
            outboundSuccess: z.ZodNumber;
            outboundFailed: z.ZodNumber;
        }, z.core.$strip>>;
        task: z.ZodOptional<z.ZodObject<{
            total: z.ZodNumber;
            open: z.ZodNumber;
            inProgress: z.ZodNumber;
            closed: z.ZodNumber;
        }, z.core.$strip>>;
        schedule: z.ZodOptional<z.ZodObject<{
            scheduleCount: z.ZodNumber;
            totalDeliveries: z.ZodNumber;
            successDeliveries: z.ZodNumber;
            failedDeliveries: z.ZodNumber;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>;
export declare const ServiceStatsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        services: z.ZodObject<{
            database: z.ZodOptional<z.ZodObject<{
                databaseCount: z.ZodNumber;
                totalTableCount: z.ZodNumber;
                totalRecordCount: z.ZodNumber;
                totalSizeBytes: z.ZodNumber;
            }, z.core.$strip>>;
            keyvalue: z.ZodOptional<z.ZodObject<{
                namespaceCount: z.ZodNumber;
                keyCount: z.ZodNumber;
                totalSizeBytes: z.ZodNumber;
            }, z.core.$strip>>;
            vector: z.ZodOptional<z.ZodObject<{
                namespaceCount: z.ZodNumber;
                documentCount: z.ZodNumber;
                totalSizeBytes: z.ZodNumber;
            }, z.core.$strip>>;
            queue: z.ZodOptional<z.ZodObject<{
                queueCount: z.ZodNumber;
                totalMessages: z.ZodNumber;
                totalDlq: z.ZodNumber;
            }, z.core.$strip>>;
            stream: z.ZodOptional<z.ZodObject<{
                streamCount: z.ZodNumber;
                totalSizeBytes: z.ZodNumber;
            }, z.core.$strip>>;
            sandbox: z.ZodOptional<z.ZodObject<{
                totalActive: z.ZodNumber;
                running: z.ZodNumber;
                idle: z.ZodNumber;
                creating: z.ZodNumber;
                totalExecutions: z.ZodNumber;
                totalCpuTimeMs: z.ZodNumber;
                totalMemoryByteSec: z.ZodNumber;
                totalNetworkEgressBytes: z.ZodNumber;
            }, z.core.$strip>>;
            email: z.ZodOptional<z.ZodObject<{
                addressCount: z.ZodNumber;
                inboundCount: z.ZodNumber;
                outboundCount: z.ZodNumber;
                outboundSuccess: z.ZodNumber;
                outboundFailed: z.ZodNumber;
            }, z.core.$strip>>;
            task: z.ZodOptional<z.ZodObject<{
                total: z.ZodNumber;
                open: z.ZodNumber;
                inProgress: z.ZodNumber;
                closed: z.ZodNumber;
            }, z.core.$strip>>;
            schedule: z.ZodOptional<z.ZodObject<{
                scheduleCount: z.ZodNumber;
                totalDeliveries: z.ZodNumber;
                successDeliveries: z.ZodNumber;
                failedDeliveries: z.ZodNumber;
            }, z.core.$strip>>;
        }, z.core.$strip>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type KeyValueStat = z.infer<typeof KeyValueStatSchema>;
export type VectorStat = z.infer<typeof VectorStatSchema>;
export type QueueStat = z.infer<typeof QueueStatSchema>;
export type StreamStat = z.infer<typeof StreamStatSchema>;
export type SandboxStat = z.infer<typeof SandboxStatSchema>;
export type EmailStat = z.infer<typeof EmailStatSchema>;
export type TaskStat = z.infer<typeof TaskStatSchema>;
export type ScheduleStat = z.infer<typeof ScheduleStatSchema>;
export type DatabaseStat = z.infer<typeof DatabaseStatSchema>;
export type ServiceStatsData = z.infer<typeof ServiceStatsDataSchema>;
export type ServiceStatsResponse = z.infer<typeof ServiceStatsResponseSchema>;
/**
 * Valid service names that can be used to filter stats.
 */
export declare const VALID_SERVICES: readonly ["database", "keyvalue", "email", "vector", "schedule", "task", "stream", "sandbox", "queue"];
export type ServiceName = (typeof VALID_SERVICES)[number];
export interface ServiceStatsOptions {
    /**
     * Filter to a specific service. If omitted, returns stats for all services.
     */
    service?: ServiceName;
    /**
     * Start time filter (ISO 8601 timestamp).
     */
    start?: string;
    /**
     * End time filter (ISO 8601 timestamp).
     */
    end?: string;
    /**
     * For CLI auth: sets x-agentuity-orgid header.
     * Required when using CLI token auth (bearer tokens without embedded org).
     */
    orgIdHeader?: string;
}
/**
 * Get aggregated stats for services used by an organization.
 *
 * Returns per-service stats with service-specific fields (counts, sizes, etc.).
 * Services that error on the backend are omitted from the response.
 * Services with no provisioned tenant DB return zero values.
 *
 * @param client - The API client instance
 * @param orgId - The organization ID
 * @param options - Optional filtering (service, time range)
 * @returns Service stats data with per-service breakdown
 * @throws {ServiceStatsError} If the API request fails
 *
 * @example
 * ```typescript
 * // Get stats for all services
 * const stats = await getServiceStats(client, 'org_123');
 * console.log(`KV keys: ${stats.services.keyvalue?.keyCount}`);
 * ```
 *
 * @example
 * ```typescript
 * // Get stats for a specific service
 * const stats = await getServiceStats(client, 'org_123', {
 *   service: 'keyvalue',
 * });
 * ```
 */
export declare function getServiceStats(client: APIClient, orgId: string, options?: ServiceStatsOptions): Promise<ServiceStatsData>;
//# sourceMappingURL=stats.d.ts.map