import { z } from 'zod';
import { type APIClient } from '../api';
export declare const DiskCheckpointInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    createdAt: z.ZodString;
    parent: z.ZodString;
}, z.core.$strip>;
export type DiskCheckpointInfo = z.infer<typeof DiskCheckpointInfoSchema>;
export declare const CreateDiskCheckpointResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        createdAt: z.ZodString;
        parent: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const ListDiskCheckpointsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        checkpoints: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            createdAt: z.ZodString;
            parent: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const RestoreDiskCheckpointResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export declare const DeleteDiskCheckpointResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export interface DiskCheckpointCreateParams {
    sandboxId: string;
    name: string;
    orgId?: string;
}
export interface DiskCheckpointListParams {
    sandboxId: string;
    orgId?: string;
}
export interface DiskCheckpointRestoreParams {
    sandboxId: string;
    checkpointId: string;
    orgId?: string;
}
export interface DiskCheckpointDeleteParams {
    sandboxId: string;
    checkpointId: string;
    orgId?: string;
}
/**
 * Creates a new disk checkpoint for a sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID and checkpoint name
 * @throws {SandboxResponseError} If the sandbox is not found or checkpoint creation fails
 */
export declare function diskCheckpointCreate(client: APIClient, params: DiskCheckpointCreateParams): Promise<DiskCheckpointInfo>;
/**
 * Lists all disk checkpoints for a sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID
 * @throws {SandboxResponseError} If the sandbox is not found or listing fails
 */
export declare function diskCheckpointList(client: APIClient, params: DiskCheckpointListParams): Promise<DiskCheckpointInfo[]>;
/**
 * Restores a sandbox to a specific disk checkpoint.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID and checkpoint ID
 * @throws {SandboxResponseError} If the sandbox or checkpoint is not found, or restore fails
 */
export declare function diskCheckpointRestore(client: APIClient, params: DiskCheckpointRestoreParams): Promise<void>;
/**
 * Deletes a disk checkpoint from a sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID and checkpoint ID
 * @throws {SandboxResponseError} If the sandbox or checkpoint is not found, or deletion fails
 */
export declare function diskCheckpointDelete(client: APIClient, params: DiskCheckpointDeleteParams): Promise<void>;
//# sourceMappingURL=disk-checkpoint.d.ts.map