import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const UpdateRegionRequestSchema: z.ZodObject<{
    cloudRegion: z.ZodString;
}, z.core.$strip>;
export declare const UpdateRegionResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
/**
 * Update a project's cloud region
 *
 * @param client - The API client
 * @param projectId - The project id to update
 * @param region - The new cloud region
 * @returns The project id on success
 */
export declare function projectUpdateRegion(client: APIClient, projectId: string, region: string): Promise<{
    id: string;
}>;
//# sourceMappingURL=update-region.d.ts.map