import { z } from 'zod';
import { type APIClient } from '../api.ts';
import type { Project } from './get.ts';
export declare const ProjectEnvUpdateRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
export declare const ProjectEnvUpdateResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        orgId: z.ZodString;
        api_key: z.ZodOptional<z.ZodString>;
        env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
type ProjectEnvUpdateRequest = z.infer<typeof ProjectEnvUpdateRequestSchema>;
/**
 * Update environment variables and/or secrets for a project.
 * This will merge the provided env/secrets with existing values.
 * Keys starting with 'AGENTUITY_' should be filtered out before calling this function.
 */
export declare function projectEnvUpdate(client: APIClient, request: ProjectEnvUpdateRequest): Promise<Project>;
export {};
//# sourceMappingURL=env-update.d.ts.map