import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const DeploymentMetadataSchema: z.ZodObject<{
    git: z.ZodOptional<z.ZodObject<{
        repo: z.ZodOptional<z.ZodString>;
        commit: z.ZodOptional<z.ZodString>;
        message: z.ZodOptional<z.ZodString>;
        branch: z.ZodOptional<z.ZodString>;
        tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
        pr: z.ZodOptional<z.ZodString>;
        provider: z.ZodOptional<z.ZodString>;
        trigger: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
        buildUrl: z.ZodOptional<z.ZodString>;
        event: z.ZodOptional<z.ZodString>;
        pull_request: z.ZodOptional<z.ZodObject<{
            number: z.ZodNumber;
            url: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    build: z.ZodOptional<z.ZodObject<{
        bun: z.ZodOptional<z.ZodString>;
        agentuity: z.ZodOptional<z.ZodString>;
        arch: z.ZodOptional<z.ZodString>;
        platform: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const DeploymentSchema: z.ZodObject<{
    id: z.ZodString;
    state: z.ZodOptional<z.ZodString>;
    message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tags: z.ZodArray<z.ZodString>;
    active: z.ZodBoolean;
    createdAt: z.ZodString;
    updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodObject<{
        git: z.ZodOptional<z.ZodObject<{
            repo: z.ZodOptional<z.ZodString>;
            commit: z.ZodOptional<z.ZodString>;
            message: z.ZodOptional<z.ZodString>;
            branch: z.ZodOptional<z.ZodString>;
            tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
            pr: z.ZodOptional<z.ZodString>;
            provider: z.ZodOptional<z.ZodString>;
            trigger: z.ZodOptional<z.ZodString>;
            url: z.ZodOptional<z.ZodString>;
            buildUrl: z.ZodOptional<z.ZodString>;
            event: z.ZodOptional<z.ZodString>;
            pull_request: z.ZodOptional<z.ZodObject<{
                number: z.ZodNumber;
                url: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
        build: z.ZodOptional<z.ZodObject<{
            bun: z.ZodOptional<z.ZodString>;
            agentuity: z.ZodOptional<z.ZodString>;
            arch: z.ZodOptional<z.ZodString>;
            platform: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    customDomains: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
    cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    resourceDb: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    resourceStorage: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    deploymentLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    buildLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    dnsRecords: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const DeploymentListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        state: z.ZodOptional<z.ZodString>;
        message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tags: z.ZodArray<z.ZodString>;
        active: z.ZodBoolean;
        createdAt: z.ZodString;
        updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodObject<{
            git: z.ZodOptional<z.ZodObject<{
                repo: z.ZodOptional<z.ZodString>;
                commit: z.ZodOptional<z.ZodString>;
                message: z.ZodOptional<z.ZodString>;
                branch: z.ZodOptional<z.ZodString>;
                tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
                pr: z.ZodOptional<z.ZodString>;
                provider: z.ZodOptional<z.ZodString>;
                trigger: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                buildUrl: z.ZodOptional<z.ZodString>;
                event: z.ZodOptional<z.ZodString>;
                pull_request: z.ZodOptional<z.ZodObject<{
                    number: z.ZodNumber;
                    url: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>>;
            build: z.ZodOptional<z.ZodObject<{
                bun: z.ZodOptional<z.ZodString>;
                agentuity: z.ZodOptional<z.ZodString>;
                arch: z.ZodOptional<z.ZodString>;
                platform: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
        customDomains: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
        cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        resourceDb: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        resourceStorage: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        deploymentLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        buildLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        dnsRecords: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export declare const DeploymentGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        state: z.ZodOptional<z.ZodString>;
        message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tags: z.ZodArray<z.ZodString>;
        active: z.ZodBoolean;
        createdAt: z.ZodString;
        updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        metadata: z.ZodOptional<z.ZodObject<{
            git: z.ZodOptional<z.ZodObject<{
                repo: z.ZodOptional<z.ZodString>;
                commit: z.ZodOptional<z.ZodString>;
                message: z.ZodOptional<z.ZodString>;
                branch: z.ZodOptional<z.ZodString>;
                tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
                pr: z.ZodOptional<z.ZodString>;
                provider: z.ZodOptional<z.ZodString>;
                trigger: z.ZodOptional<z.ZodString>;
                url: z.ZodOptional<z.ZodString>;
                buildUrl: z.ZodOptional<z.ZodString>;
                event: z.ZodOptional<z.ZodString>;
                pull_request: z.ZodOptional<z.ZodObject<{
                    number: z.ZodNumber;
                    url: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>>;
            }, z.core.$strip>>;
            build: z.ZodOptional<z.ZodObject<{
                bun: z.ZodOptional<z.ZodString>;
                agentuity: z.ZodOptional<z.ZodString>;
                arch: z.ZodOptional<z.ZodString>;
                platform: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
        customDomains: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
        cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        resourceDb: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        resourceStorage: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        deploymentLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        buildLogsURL: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        dnsRecords: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const DeploymentActionResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodOptional<z.ZodObject<{
        activeDeploymentId: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type DeploymentInfo = z.infer<typeof DeploymentSchema>;
export declare function projectDeploymentList(client: APIClient, projectId: string, limit?: number, options?: {
    orgId?: string;
}): Promise<DeploymentInfo[]>;
export declare function projectDeploymentGet(client: APIClient, projectId: string, deploymentId: string): Promise<DeploymentInfo>;
export declare const DeploymentLookupSchema: z.ZodObject<{
    id: z.ZodString;
    projectId: z.ZodString;
    orgId: z.ZodString;
    cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    state: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    active: z.ZodBoolean;
}, z.core.$strip>;
export declare const DeploymentLookupResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        projectId: z.ZodString;
        orgId: z.ZodString;
        cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        state: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        active: z.ZodBoolean;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type DeploymentLookup = z.infer<typeof DeploymentLookupSchema>;
/**
 * Get deployment info by ID only (without requiring project ID).
 * Useful for looking up region/project info for a deployment.
 */
export declare function deploymentGet(client: APIClient, deploymentId: string): Promise<DeploymentLookup>;
export declare function projectDeploymentDelete(client: APIClient, projectId: string, deploymentId: string): Promise<void>;
export declare function projectDeploymentRollback(client: APIClient, projectId: string, deploymentId: string): Promise<void>;
export declare function projectDeploymentUndeploy(client: APIClient, projectId: string): Promise<void>;
export declare const DeploymentLogSchema: z.ZodObject<{
    body: z.ZodString;
    severity: z.ZodString;
    timestamp: z.ZodString;
    spanId: z.ZodString;
    traceId: z.ZodString;
    serviceName: z.ZodString;
}, z.core.$strip>;
export declare const DeploymentLogsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        body: z.ZodString;
        severity: z.ZodString;
        timestamp: z.ZodString;
        spanId: z.ZodString;
        traceId: z.ZodString;
        serviceName: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type DeploymentLog = z.infer<typeof DeploymentLogSchema>;
export declare function projectDeploymentLogs(client: APIClient, projectId: string, deploymentId: string, limit?: number): Promise<DeploymentLog[]>;
//# sourceMappingURL=deployment.d.ts.map