/**
 * Shared HMAC-SHA256 signature verification for internal routes.
 * Used by cron handlers and workbench routes.
 */
/**
 * Verifies an HMAC-SHA256 signature.
 *
 * The signature format is "v1=<64 hex chars>" where the hex payload is the
 * HMAC-SHA256 of "{timestamp}.{body}" using AGENTUITY_SDK_KEY as the key.
 *
 * In non-production environments (dev mode), this function always returns true
 * to allow local development without signature verification.
 *
 * In production, requests are rejected if AGENTUITY_SDK_KEY is not set.
 *
 * @param signature - The signature header value (format: "v1=<64 hex chars>")
 * @param timestamp - The timestamp header value (unix seconds as string)
 * @param body - The request body (empty string for GET/DELETE requests)
 * @returns true if signature is valid, or if not in production mode
 */
export declare function verifySignature(signature: string | undefined, timestamp: string | undefined, body: string): Promise<boolean>;
//# sourceMappingURL=signature.d.ts.map