import type { Database } from 'bun:sqlite';
import type { TaskStorage, Task, CreateTaskParams, UpdateTaskParams, ListTasksParams, ListTasksResult, TaskChangelogResult } from '@agentuity/core';
export declare class LocalTaskStorage implements TaskStorage {
    #private;
    constructor(db: Database, projectPath: string);
    create(params: CreateTaskParams): Promise<Task>;
    get(id: string): Promise<Task | null>;
    list(params?: ListTasksParams): Promise<ListTasksResult>;
    update(id: string, params: UpdateTaskParams): Promise<Task>;
    close(id: string): Promise<Task>;
    changelog(id: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<TaskChangelogResult>;
}
//# sourceMappingURL=task.d.ts.map