import { type EmailService, type EmailAddress, type EmailDestination, type EmailInbound, type EmailOutbound, type EmailSendParams } from '@agentuity/core';
/**
 * Local development stub for the email service.
 * All methods throw a descriptive error directing users to deploy to Agentuity Cloud.
 */
export declare class LocalEmailStorage implements EmailService {
    createAddress(_localPart: string): Promise<EmailAddress>;
    listAddresses(): Promise<EmailAddress[]>;
    getAddress(_id: string): Promise<EmailAddress | null>;
    deleteAddress(_id: string): Promise<void>;
    createDestination(_addressId: string, _type: string, _config: Record<string, unknown>): Promise<EmailDestination>;
    listDestinations(_addressId: string): Promise<EmailDestination[]>;
    deleteDestination(_addressId: string, _destinationId: string): Promise<void>;
    send(_params: EmailSendParams): Promise<EmailOutbound>;
    listInbound(_addressId?: string): Promise<EmailInbound[]>;
    getInbound(_id: string): Promise<EmailInbound | null>;
    listOutbound(_addressId?: string): Promise<EmailOutbound[]>;
    getOutbound(_id: string): Promise<EmailOutbound | null>;
}
//# sourceMappingURL=email.d.ts.map