import { z } from 'zod';
import type { SkillsConfig } from './skills/types';
import type { TmuxConfig } from './tmux/types';
export type { Plugin, PluginInput, Hooks as PluginHooks, ToolDefinition, } from '@opencode-ai/plugin';
export type { SkillsConfig, LoadedSkill, SkillMetadata, SkillScope } from './skills';
export type { TmuxConfig } from './tmux/types';
export declare const AgentRoleSchema: z.ZodEnum<{
    lead: "lead";
    scout: "scout";
    builder: "builder";
    architect: "architect";
    reviewer: "reviewer";
    memory: "memory";
    expert: "expert";
    "expert-backend": "expert-backend";
    "expert-frontend": "expert-frontend";
    "expert-ops": "expert-ops";
    runner: "runner";
    product: "product";
}>;
export type AgentRole = z.infer<typeof AgentRoleSchema>;
export declare const TaskStatusSchema: z.ZodEnum<{
    pending: "pending";
    running: "running";
    completed: "completed";
    failed: "failed";
    cancelled: "cancelled";
}>;
export type TaskStatus = z.infer<typeof TaskStatusSchema>;
export declare const OrchestrationPatternSchema: z.ZodEnum<{
    single: "single";
    fanout: "fanout";
    pipeline: "pipeline";
}>;
export type OrchestrationPattern = z.infer<typeof OrchestrationPatternSchema>;
export declare const CadenceStatusSchema: z.ZodEnum<{
    running: "running";
    completed: "completed";
    failed: "failed";
    cancelled: "cancelled";
    paused: "paused";
}>;
export type CadenceStatus = z.infer<typeof CadenceStatusSchema>;
export declare const CadenceSandboxModeSchema: z.ZodEnum<{
    off: "off";
    per_iteration: "per_iteration";
    persistent: "persistent";
}>;
export type CadenceSandboxMode = z.infer<typeof CadenceSandboxModeSchema>;
export interface CadenceLoop {
    loopId: string;
    parentId?: string;
    projectLabel?: string;
    sessionId?: string;
    status: CadenceStatus;
    iteration: number;
    maxIterations: number;
    prompt: string;
    createdAt: string;
    updatedAt: string;
    lastError?: string;
    sandbox?: {
        mode: CadenceSandboxMode;
        sandboxId?: string;
    };
}
export interface AgentConfig {
    /** Agent description - explains what it does and when to use it */
    description: string;
    /** Model ID in provider/model-id format */
    model: string;
    /** System prompt content (not a file path) */
    prompt: string;
    /** Agent mode: 'primary', 'subagent', or 'all' (default) */
    mode?: 'primary' | 'subagent' | 'all';
    /** Tool configuration */
    tools?: Record<string, boolean>;
    /** Model variant for thinking/reasoning (e.g., 'high', 'max' for Anthropic) */
    variant?: string;
    /** Temperature for response creativity (0.0-2.0) */
    temperature?: number;
    /** Maximum agentic steps before forcing text response */
    maxSteps?: number;
    /** Reasoning effort for OpenAI models */
    reasoningEffort?: ReasoningEffort;
    /** Extended thinking configuration for Anthropic models */
    thinking?: ThinkingConfig;
    /**
     * Ordered list of fallback model IDs to try when the primary model fails
     * with a retryable error (429 rate limit, 500/502/503 server error).
     * Models are tried in order until one succeeds.
     *
     * Example: ['anthropic/claude-sonnet-4-20250514', 'openai/gpt-4.1']
     */
    fallbackModels?: string[];
    /** Hidden from @ autocomplete */
    hidden?: boolean;
}
export interface AgentContext {
    projectRoot: string;
    orgId?: string;
    sessionId?: string;
    taskId?: string;
}
export interface CoderTask {
    id: string;
    title: string;
    description?: string;
    status: TaskStatus;
    createdAt: Date;
    updatedAt: Date;
    assignedTo?: AgentRole;
    parentTaskId?: string;
    result?: string;
    error?: string;
}
/** Extended thinking configuration for Anthropic models */
export declare const ThinkingConfigSchema: z.ZodObject<{
    type: z.ZodEnum<{
        enabled: "enabled";
        disabled: "disabled";
    }>;
    budgetTokens: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
export type ThinkingConfig = z.infer<typeof ThinkingConfigSchema>;
/** Reasoning effort for OpenAI models */
export declare const ReasoningEffortSchema: z.ZodEnum<{
    low: "low";
    medium: "medium";
    high: "high";
    xhigh: "xhigh";
}>;
export type ReasoningEffort = z.infer<typeof ReasoningEffortSchema>;
/** Model variant for Anthropic thinking levels */
export declare const ModelVariantSchema: z.ZodEnum<{
    low: "low";
    medium: "medium";
    high: "high";
    max: "max";
}>;
export type ModelVariant = z.infer<typeof ModelVariantSchema>;
/** Enhanced agent model configuration */
export interface AgentModelConfig {
    /** Model ID in provider/model-id format */
    model?: string;
    /** Temperature for response creativity (0.0-2.0) */
    temperature?: number;
    /** Model variant for Anthropic thinking levels */
    variant?: ModelVariant;
    /** Reasoning effort for OpenAI models */
    reasoningEffort?: ReasoningEffort;
    /** Extended thinking configuration for Anthropic models */
    thinking?: ThinkingConfig;
    /** Maximum agentic steps before forcing text response */
    maxSteps?: number;
}
export declare const AgentModelConfigSchema: z.ZodObject<{
    model: z.ZodOptional<z.ZodString>;
    temperature: z.ZodOptional<z.ZodNumber>;
    variant: z.ZodOptional<z.ZodEnum<{
        low: "low";
        medium: "medium";
        high: "high";
        max: "max";
    }>>;
    reasoningEffort: z.ZodOptional<z.ZodEnum<{
        low: "low";
        medium: "medium";
        high: "high";
        xhigh: "xhigh";
    }>>;
    thinking: z.ZodOptional<z.ZodObject<{
        type: z.ZodEnum<{
            enabled: "enabled";
            disabled: "disabled";
        }>;
        budgetTokens: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>>;
    maxSteps: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
/** Configuration for compaction behavior */
export interface CompactionConfig {
    /** Use custom compaction prompt tailored to our agent system (default: true) */
    customPrompt?: boolean;
    /** Inline planning state from KV into compaction context (default: true) */
    inlinePlanning?: boolean;
    /** Detect and describe images/attachments (default: true) */
    imageAwareness?: boolean;
    /** Number of recent tool calls to summarize (default: 5, 0 to disable) */
    toolCallSummaryLimit?: number;
    /** Store pre-compaction snapshot to KV for recovery (default: true) */
    snapshotToKV?: boolean;
    /** Max tokens budget for ALL injected compaction context combined (default: 4000) */
    maxContextTokens?: number;
    /** Reserved token buffer for compaction prompts (default: 40000). Must not exceed OpenCode's max context window. */
    reserved?: number;
}
export interface CoderConfig {
    org?: string;
    disabledMcps?: string[];
    /** CLI command patterns to block for security (e.g., 'cloud secrets', 'auth token') */
    blockedCommands?: string[];
    skills?: SkillsConfig;
    tmux?: TmuxConfig;
    compaction?: CompactionConfig;
}
export declare const SkillsConfigSchema: z.ZodObject<{
    enabled: z.ZodBoolean;
    paths: z.ZodOptional<z.ZodArray<z.ZodString>>;
    disabled: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const TmuxConfigSchema: z.ZodObject<{
    enabled: z.ZodBoolean;
    maxPanes: z.ZodNumber;
    mainPaneMinWidth: z.ZodNumber;
    agentPaneMinWidth: z.ZodNumber;
}, z.core.$strip>;
export declare const CompactionConfigSchema: z.ZodObject<{
    customPrompt: z.ZodOptional<z.ZodBoolean>;
    inlinePlanning: z.ZodOptional<z.ZodBoolean>;
    imageAwareness: z.ZodOptional<z.ZodBoolean>;
    toolCallSummaryLimit: z.ZodOptional<z.ZodNumber>;
    snapshotToKV: z.ZodOptional<z.ZodBoolean>;
    maxContextTokens: z.ZodOptional<z.ZodNumber>;
    reserved: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
export declare const CoderConfigSchema: z.ZodObject<{
    org: z.ZodOptional<z.ZodString>;
    disabledMcps: z.ZodOptional<z.ZodArray<z.ZodString>>;
    blockedCommands: z.ZodOptional<z.ZodArray<z.ZodString>>;
    skills: z.ZodOptional<z.ZodObject<{
        enabled: z.ZodBoolean;
        paths: z.ZodOptional<z.ZodArray<z.ZodString>>;
        disabled: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>>;
    tmux: z.ZodOptional<z.ZodObject<{
        enabled: z.ZodBoolean;
        maxPanes: z.ZodNumber;
        mainPaneMinWidth: z.ZodNumber;
        agentPaneMinWidth: z.ZodNumber;
    }, z.core.$strip>>;
    compaction: z.ZodOptional<z.ZodObject<{
        customPrompt: z.ZodOptional<z.ZodBoolean>;
        inlinePlanning: z.ZodOptional<z.ZodBoolean>;
        imageAwareness: z.ZodOptional<z.ZodBoolean>;
        toolCallSummaryLimit: z.ZodOptional<z.ZodNumber>;
        snapshotToKV: z.ZodOptional<z.ZodBoolean>;
        maxContextTokens: z.ZodOptional<z.ZodNumber>;
        reserved: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export interface McpConfig {
    name: string;
    type: 'remote';
    url: string;
    enabled: boolean;
    headers?: Record<string, string>;
}
export interface CommandDefinition {
    name: string;
    description?: string;
    template: string;
    agent?: string;
    model?: string;
    argumentHint?: string;
    /** Force command to run as subagent for context isolation */
    subtask?: boolean;
}
//# sourceMappingURL=types.d.ts.map