import type { PluginInput } from '@opencode-ai/plugin';
import type { CoderConfig } from '../../types';
export interface ToolHooks {
    before: (input: unknown, output: unknown) => Promise<void>;
    after: (input: unknown, output: unknown) => Promise<void>;
}
/**
 * Get the Agentuity profile to use for CLI commands.
 * Defaults to 'production' for safety, but can be overridden via AGENTUITY_CODER_PROFILE.
 */
export declare function getCoderProfile(): string;
export declare function createToolHooks(ctx: PluginInput, config: CoderConfig): ToolHooks;
export declare function getEntityContextForSession(): Promise<{
    userId?: string;
    orgId?: string;
    projectId?: string;
    repoId?: string;
}>;
//# sourceMappingURL=tools.d.ts.map