import type { PluginInput } from '@opencode-ai/plugin';
import type { CoderConfig } from '../../types';
import type { OpenCodeDBReader } from '../../sqlite';
export interface SessionMemoryHooks {
    onEvent: (input: {
        event: {
            type: string;
            properties?: Record<string, unknown>;
        };
    }) => Promise<void>;
    onCompacting: (input: {
        sessionID: string;
    }, output: {
        context: string[];
        prompt?: string;
    }) => Promise<void>;
}
/**
 * Session memory hooks handle compaction for non-Cadence sessions.
 *
 * Strategy:
 * 1. On compacting: Inject Memory system info into compaction prompt
 * 2. On session.compacted: Tell Lead to have Memory save the summary (it's already in context!)
 */
export declare function createSessionMemoryHooks(ctx: PluginInput, config: CoderConfig, dbReader?: OpenCodeDBReader): SessionMemoryHooks;
//# sourceMappingURL=session-memory.d.ts.map