import { FetchAdapter } from './adapter.ts';
export interface Schedule {
    id: string;
    created_at: string;
    updated_at: string;
    created_by: string;
    name: string;
    description: string | null;
    expression: string;
    due_date: string;
}
export interface ScheduleDestination {
    id: string;
    schedule_id: string;
    created_at: string;
    updated_at: string;
    created_by: string;
    type: 'url' | 'sandbox';
    config: Record<string, unknown>;
}
export interface ScheduleDelivery {
    id: string;
    date: string;
    schedule_id: string;
    schedule_destination_id: string;
    status: 'pending' | 'success' | 'failed';
    retries: number;
    error: string | null;
    response: Record<string, unknown> | null;
}
export interface CreateScheduleParams {
    name: string;
    description?: string;
    expression: string;
    destinations?: CreateScheduleDestinationParams[];
}
export interface CreateScheduleDestinationParams {
    type: 'url' | 'sandbox';
    config: Record<string, unknown>;
}
export interface UpdateScheduleParams {
    name?: string;
    description?: string;
    expression?: string;
}
export interface ScheduleListResult {
    schedules: Schedule[];
    total: number;
}
export interface ScheduleGetResult {
    schedule: Schedule;
    destinations: ScheduleDestination[];
}
export interface ScheduleCreateResult {
    schedule: Schedule;
    destinations: ScheduleDestination[];
}
export interface ScheduleDeliveryListResult {
    deliveries: ScheduleDelivery[];
}
export declare class ScheduleService {
    #private;
    constructor(baseUrl: string, adapter: FetchAdapter);
    create(params: CreateScheduleParams): Promise<ScheduleCreateResult>;
    list(params?: {
        limit?: number;
        offset?: number;
    }): Promise<ScheduleListResult>;
    get(scheduleId: string): Promise<ScheduleGetResult>;
    update(scheduleId: string, params: UpdateScheduleParams): Promise<{
        schedule: Schedule;
    }>;
    delete(scheduleId: string): Promise<void>;
    createDestination(scheduleId: string, params: CreateScheduleDestinationParams): Promise<{
        destination: ScheduleDestination;
    }>;
    deleteDestination(destinationId: string): Promise<void>;
    listDeliveries(scheduleId: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<ScheduleDeliveryListResult>;
    getDestination(scheduleId: string, destinationId: string): Promise<ScheduleDestination>;
    getDelivery(scheduleId: string, deliveryId: string, params?: {
        limit?: number;
        offset?: number;
    }): Promise<ScheduleDelivery>;
}
//# sourceMappingURL=schedule.d.ts.map